/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.pa.util;

import com.ibm.hwmca.fw.log.Log;
import com.ibm.hwmca.fw.log.LogAttributes;
import com.ibm.hwmca.fw.util.HexString;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedReader;
import java.io.InputStreamReader;

public class Relogger {
    private static final String TRACE_MASKT = "RELOG  T";
    private static final String TRACE_MASKF = "RELOG  F";
    private static final String TRACE_MASKD = "RELOG  D";
    static String[] supportedLogs = new String[]{"hydra1", "ipl", "serial1", "lir1", "lir2", "lir3", "lir4", "lir5", "lir6", "lir7", "etr0", "etr1", "etrI"};
    static byte logClass = (byte)27;
    static byte logType = (byte)2;
    static boolean relog = true;
    static boolean cannedlog = false;
    static boolean end = false;
    static boolean showHelp = true;
    static String cannedLogType = "";

    public static void main(String[] args) {
        try {
            System.out.println("Relogger running\n\n V 1.0");
            Trace.trace(TRACE_MASKD, "-->Relogger()");
            Relogger.parseOptions(args);
            if (showHelp) {
                System.out.println("\nValid options are:");
                System.out.println("-class xxx, where xx it the log class to retrieve");
                System.out.println("-type  yyy, where yy it the log type to retrieve");
                System.out.println("-test  zzz, where zzz is one of the following");
                for (int i = 0; i < supportedLogs.length; ++i) {
                    System.out.println("    " + supportedLogs[i]);
                }
                System.out.println("-help - shows this help\n");
                return;
            }
            if (relog) {
                Log[] retrievedLogs = Log.retrieve(new Byte(logClass), new Byte(logType), null, null, null, null, null, null);
                System.out.println("number of logs that matched is " + retrievedLogs.length);
                for (int i = 0; i < retrievedLogs.length; ++i) {
                    String currentLine;
                    System.out.println("Do you want to relog " + retrievedLogs[i] + " [y/n/q]?");
                    BufferedReader inStream = new BufferedReader(new InputStreamReader(System.in));
                    while ((currentLine = inStream.readLine()) != null) {
                        if (currentLine.equals("q")) {
                            System.out.println("Hasta la vista, baby!\n");
                            end = true;
                            break;
                        }
                        if (currentLine.equals("y")) {
                            System.out.println("Let it be written, let it be so.\n");
                            break;
                        }
                        if (!currentLine.equals("n")) continue;
                        System.out.println("Be that way then.\n");
                        break;
                    }
                    if (end) break;
                }
            }
            if (cannedlog) {
                System.out.println("Issuing a fixed log of type " + cannedLogType);
                Relogger.logCanned(cannedLogType);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("\nDone\n");
        Trace.trace(TRACE_MASKD, "<--Relogger()");
    }

    static void parseOptions(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].toLowerCase().startsWith("-class")) {
                showHelp = false;
                ++i;
                break;
            }
            if (args[i].toLowerCase().startsWith("-type")) {
                showHelp = false;
                ++i;
                break;
            }
            if (args[i].toLowerCase().startsWith("-help")) {
                showHelp = true;
            }
            if (!args[i].toLowerCase().startsWith("-test")) continue;
            cannedlog = true;
            relog = false;
            if (++i < args.length) {
                cannedLogType = args[i];
                showHelp = false;
                continue;
            }
            System.out.println("you need to specify a type of log.");
        }
    }

    static void logCanned(String cannedLogType) {
        boolean foundit = false;
        byte logClass = 0;
        byte logType = 0;
        short user = 0;
        String name = "PA TEST LOG";
        String towerData = "PA TEST LOG";
        byte[] data = null;
        Object cData = null;
        if (cannedLogType.equals("hydra1")) {
            foundit = true;
            logClass = 27;
            logType = 2;
            name = "HYDRA1";
            data = new byte[]{0, -126, 0, 0, 0, 0, 0, 0, 0, -127, 0, 0, 0, 0, 0, 0, 0, -125, 0, 0, 0, 0, 0, 0, 0, 0, 1, -125, 4, 0, 0, 0, 0, 0, 7, 11, 0, 0, 0, 0, 0, 0, 4, -127, 37, 0, 0, 0, 0, 0, 50, 50, 52, 51, 50, 48, 50, 48, 0, 56, 54, 48, 49, 51, 48, 48, 69, 0, 48, 48, 50, 48, 66, 52, 49, 65, 0, 66, 66, 82, 69, 72, 88, 88, 88, 0, 64, 0, 0, 2, -127, 9, 0, 0, 0, 0, 0, 31, 14, 0, 0, 122, -47, 7, 66, 41, 0, 0, 0, 0, 2, -126, 30, 0, 0, 0, 0, 0, 9, 0, 2, 5, 113, 65, 48, 49, 66, 76, 71, 48, 52, 74, 46, 48, 48, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, -124, 115, 0, 0, 0, 0, 0, 68, -111, 1, 48, 99, 2, 2, 0, 0, 0, 0, 0, 0, 0, 18, 0, -112, -4, -2, -2, 117, 99, 117, 89, 0, 0, -60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 64, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 3, 16, -48, -93, 64, 16, 4, -5, -56, 0, 0, 16, 0, 17, -106, -48, -88, 0, 0, 5, -28, 0, 0, 0, 2, 18, 13, 58, -128, 16, 4, -5, -104, 0, 0, 0, 0, 16, 4, -5, -72, 0, 0, 0, 18, 17, -112, -54, -80, 0, 0, 0, 0, 0, 0, 0};
        }
        if (cannedLogType.equals("ipl")) {
            foundit = true;
            logClass = 27;
            logType = 1;
            name = "ipl";
            data = new byte[]{0, -126, 0, 0, 0, 0, 0, 0, 0, -127, 0, 0, 0, 0, 0, 0, 0, -125, 0, 0, 0, 0, 0, 0, 0, 0, 1, -125, 4, 0, 0, 0, 0, 0, 5, 11, 3, 1, 0, 0, 0, 0, 4, -127, 37, 0, 0, 0, 0, 0, 50, 50, 51, 54, 48, 48, 49, 53, 0, 56, 51, 48, 48, 48, 48, 57, 57, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 66, 66, 82, 69, 83, 88, 88, 88, 0, 0, 0, 0, 2, -127, 9, 0, 0, 0, 0, 0, 3, 2, 1, 0, -49, 61, 31, 66, 16, 0, 0, 0, 0, 1, -126, 48, 0, 0, 0, 0, 0, 8, 0, 0, -18, -103, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 69, 69, 49, 57, 65, 51, 65, 32, 0, 0, 0, 0, 0};
        }
        if (cannedLogType.equals("serial1")) {
            foundit = true;
            logClass = 27;
            logType = 2;
            name = "serial1";
            data = HexString.toHexBytes("00820000000000000081000000000000008300000000000000000183040000000000050b0000000000000481250000000000323234353130464600384230313030464200383030303033303300626272656378787800800000028109000000000013010000eaad264261000000000282200000000000020002002220000000000000000000000000000000000000000000000000000000000000");
        }
        if (cannedLogType.equals("lir1")) {
            foundit = true;
            logClass = 22;
            logType = 2;
            name = "lir1";
            data = new byte[]{8, 3, 0, 0, 16, 0, 1, 0, -16, -16, -14, -16, -8, -12, -61, -14, -12, -55, -62, -44, -16, -16, -16, -16, -16, -16, -16, -16, -16, -15, -10, -58, -61, -63, -128, 0, 0, 0, 1, 0, -16, -16, -13, -7, -7, -16, -16, -16, -10, -55, -62, -44, -15, -13, -16, -16, -16, -16, -16, -16, -16, -7, -12, -13, -7, -12, 0, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        }
        if (cannedLogType.equals("lir2")) {
            foundit = true;
            logClass = 22;
            logType = 2;
            name = "lir2";
            data = new byte[]{8, 1, 0, 0, 16, 0, 1, 0, -16, -16, -14, -16, -8, -12, -61, -14, -12, -55, -62, -44, -16, -16, -16, -16, -16, -16, -16, -16, -16, -15, -10, -58, -61, -63, -128, 0, 0, 0, 1, 0, -16, -16, -13, -7, -7, -16, -16, -16, -10, -55, -62, -44, -15, -13, -16, -16, -16, -16, -16, -16, -16, -7, -12, -13, -7, -12, 0, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        }
        if (cannedLogType.equals("lir3")) {
            foundit = true;
            logClass = 22;
            logType = 2;
            name = "lir3";
            data = new byte[]{8, 4, 0, 0, 16, 0, 1, 0, -16, -16, -14, -16, -8, -12, -61, -14, -12, -55, -62, -44, -16, -16, -16, -16, -16, -16, -16, -16, -16, -15, -10, -58, -61, -63, -128, 0, 0, 0, 1, 0, -16, -16, -13, -7, -7, -16, -16, -16, -10, -55, -62, -44, -15, -13, -16, -16, -16, -16, -16, -16, -16, -7, -12, -13, -7, -12, 0, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        }
        if (cannedLogType.equals("lir4")) {
            foundit = true;
            logClass = 22;
            logType = 2;
            name = "lir4";
            data = new byte[]{8, 4, 0, 0, 16, 0, 1, 0, -16, -16, -13, -7, -7, -16, -16, -16, -10, -55, -62, -44, -15, -13, -16, -16, -16, -16, -16, -16, -16, -7, -12, -13, -7, -12, -128, 0, 0, 0, 1, 0, -16, -16, -14, -16, -8, -12, -61, -14, -12, -55, -62, -44, -16, -16, -16, -16, -16, -16, -16, -16, -16, -15, -10, -58, -61, -63, 0, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        }
        if (cannedLogType.equals("lir5")) {
            foundit = true;
            logClass = 22;
            logType = 2;
            name = "lir5";
            data = new byte[]{9, 3, 0, 0, 0, 0, 1, 0, -16, -16, -13, -7, -7, -16, -16, -16, -10, -55, -62, -44, -15, -13, -16, -16, -16, -16, -16, -16, -16, -7, -13, -8, -14, -11, 0, 17, 16, 0, 1, 18, -16, -16, -14, -16, -7, -12, -23, -16, -8, -55, -62, -44, -16, -16, -16, -16, -16, -16, -16, -16, -16, -14, -16, -63, -58, -59, 64, 18, 1, 0, 64, 64, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        }
        if (cannedLogType.equals("lir6")) {
            foundit = true;
            logClass = 22;
            logType = 2;
            name = "lir6";
            data = new byte[]{9, 3, 0, 0, 0, 0, 1, 0, -16, -16, -13, -7, -7, -16, -16, -16, -10, -55, -62, -44, -15, -13, -16, -16, -16, -16, -16, -16, -16, -7, -12, -13, -7, -12, 0, 17, 16, 0, 1, 0, -16, -16, -14, -16, -7, -12, -23, -16, -8, -55, -62, -44, -16, -16, -16, -16, -16, -16, -16, -16, -16, -14, -16, -63, -58, -59, -128, 0, 1, 0, 64, 64, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        }
        if (cannedLogType.equals("lir7")) {
            foundit = true;
            logClass = 22;
            logType = 2;
            name = "lir7";
            data = new byte[]{9, 3, 0, 0, 0, 0, 1, 0, -16, -16, -13, -7, -7, -16, -16, -16, -10, -55, -62, -44, -15, -13, -16, -16, -16, -16, -16, -16, -16, -7, -12, -13, -7, -12, 0, 1, 16, 0, 1, 16, -16, -16, -14, -16, -7, -12, -23, -16, -8, -55, -62, -44, -16, -16, -16, -16, -16, -16, -16, -16, -16, -14, -16, -63, -58, -59, 64, 16, 1, 0, 64, 64, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        }
        if (cannedLogType.equals("etr1")) {
            foundit = true;
            logClass = 5;
            logType = -95;
            name = "etr1";
            data = new byte[]{-95, -125, 80, 0, 0, 0, 0, 0, -68, -123, -68, 51, -36, -43, -42, 14, 0, 7, 83, 74, 32, -124, -128, 0, -56, -60, -128, 34, -16, 0, 0, -16, -68, -123, -1, 66, 0, 0, 26, 0, 32, 15, 12, 17, -68, -123, -1, 66, 0, 18, 108, -128, 0, 64, 4, -49, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15, 13, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -55, -59, -63, -14, -10, -14, -55, 64, -59, -29, -39, 64, -41, -42, -39, -29, 64, -15, 64, -55, -30, 64, -43, -42, -29, 64, -42, -41, -59, -39, -63, -29, -55, -42, -43, -63, -45, 75, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 0};
        }
        if (cannedLogType.equals("etr0")) {
            foundit = true;
            logClass = 5;
            logType = -95;
            name = "etr0";
            data = new byte[]{-95, -125, 80, 0, 0, 0, 0, 0, -68, -123, -68, 51, -36, -43, -101, 78, 0, 7, 83, 74, 32, -124, -128, 0, -56, -60, -128, 34, -16, 0, 0, -16, -68, -123, -1, 66, 0, 0, 26, 0, 32, 15, 12, 17, -68, -123, -1, 66, 0, 18, 108, -128, 0, 64, 4, -49, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15, 13, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -55, -59, -63, -14, -10, -14, -55, 64, -59, -29, -39, 64, -41, -42, -39, -29, 64, -16, 64, -55, -30, 64, -43, -42, -29, 64, -42, -41, -59, -39, -63, -29, -55, -42, -43, -63, -45, 75, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 0};
        }
        if (cannedLogType.equals("etrI")) {
            foundit = true;
            logClass = 5;
            logType = -95;
            name = "etrI";
            data = new byte[]{-95, -125, 80, 0, 0, 0, 0, 0, -68, -123, -30, 62, -63, -8, 32, -114, 0, 8, 83, 74, 32, -124, -128, 0, -56, 0, -128, 34, -16, 0, 0, -16, -68, -123, -30, 62, 0, 56, 90, 0, 32, 15, 12, 17, -68, -123, -30, 62, 0, 18, 108, -128, 0, 64, 4, -49, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -55, -59, -63, -14, -10, -15, -55, 64, -43, -42, 64, -59, -29, -39, 64, -41, -42, -39, -29, -30, 64, -63, -39, -59, 64, -28, -30, -63, -62, -45, -59, 75, 64, -61, -41, -61, 64, -61, -42, -43, -29, -55, -43, -28, -59, -30, 64, -29, -42, 64, -39, -28, -43, 64, -55, -43, 64, -45, -42, -61, -63, -45, 64, -44, -42, -60, -59, 75, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 0};
        }
        if (cannedLogType.equals("power")) {
            foundit = true;
            logClass = 27;
            logType = 1;
            name = "power";
            data = new byte[]{0, -126, 0, 0, 0, 0, 0, 0, 0, -127, 0, 0, 0, 0, 0, 0, 0, -125, 0, 0, 0, 0, 0, 0, 0, 0, 1, -125, 4, 0, 0, 0, 0, 0, 5, 11, 3, 1, 0, 0, 0, 0, 4, -127, 37, 0, 0, 0, 0, 0, 50, 50, 51, 54, 48, 48, 49, 53, 0, 56, 51, 48, 48, 48, 48, 57, 57, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 66, 66, 82, 69, 83, 88, 88, 88, 0, 0, 0, 0, 2, -127, 9, 0, 0, 0, 0, 0, 3, 2, 1, 0, -49, 61, 31, 66, 16, 0, 0, 0, 0, 1, -126, 48, 0, 0, 0, 0, 0, 8, 0, 0, -18, -103, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 69, 69, 49, 57, 65, 51, 65, 32, 0, 0, 0, 0, 0};
        }
        if (foundit) {
            Log theLog = new Log(logClass, logType, user, name, null, null, null, towerData);
            theLog.add((byte)3, data);
            theLog.log(LogAttributes.ERROR_LOG);
        } else {
            System.out.println("So sorry I wasn't able to find the log you wanted.");
            System.out.println("Please specify one of the following");
            System.out.println(supportedLogs);
        }
    }
}

